﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Diagnostics;

namespace KursBeispiele
{
    public partial class Form1 : Form
    {
        delegate void AddTextDelegate(string p, Color c);

        AddTextDelegate atd;
        Process p;
        string titelBuffer;

        public Form1()
        {
            atd = new AddTextDelegate(AddText);
            InitializeComponent();
            titelBuffer = Text;
        }

        //Startet die bessere Konsole
        private void button1_Click(object sender, EventArgs e)
        {
            button1.Visible = false;
            button2.Visible = true;
            input.ReadOnly = false;

            p = new Process();
            p.StartInfo = new ProcessStartInfo("cmd");
            //Wir wollen das Fenster nicht sehen
            p.StartInfo.CreateNoWindow = true;
            //Ausgaben und Eingeben redirecten
            p.StartInfo.RedirectStandardInput = true;
            p.StartInfo.RedirectStandardError = true;
            p.StartInfo.RedirectStandardOutput = true;
            //Muss hier leider verwendet werden
            p.StartInfo.UseShellExecute = false;
            p.StartInfo.StandardOutputEncoding = Encoding.ASCII;
            p.StartInfo.StandardErrorEncoding = Encoding.ASCII;
            p.Exited += new EventHandler(p_Exited);
            //Callbacks
            p.ErrorDataReceived += new DataReceivedEventHandler(p_ErrorDataReceived);
            //Callbacks
            p.OutputDataReceived += new DataReceivedEventHandler(p_OutputDataReceived);
            p.StartInfo.WorkingDirectory = Application.StartupPath;
            p.Start();

            //Brauchen wir um die Sachen umzuleiten
            p.BeginOutputReadLine();
            p.BeginErrorReadLine();

            Text = titelBuffer + " [ läuft ]";
        }

        //Beendet die Konsole - killt den Prozess
        private void button2_Click(object sender, EventArgs e)
        {
            button1.Visible = true;
            button2.Visible = false;
            input.ReadOnly = true;
            p.Kill();
            p_Exited(sender, e);
        }

        //Wird aufgerufen wenn die Eingabebox beendet wird
        private void p_Exited(object sender, EventArgs e)
        {
            Text = titelBuffer + " [ beendet ]";
        }

        //Error received - wollen den Rot darstellen
        private void p_ErrorDataReceived(object sender, DataReceivedEventArgs e)
        {
            AddText(e.Data, Color.Red);
        }

        //Output received
        private void p_OutputDataReceived(object sender, DataReceivedEventArgs e)
        {
            AddText(e.Data, Color.Green);
        }

        //Text hinzufügen - VORSICHT: Kommt von anderem Thread (da andere Anwendung!)
        private void AddText(string p, Color c)
        {
            if (this.InvokeRequired)
                Invoke(atd, p, c);
            else
            {
                output.SelectionColor = c;
                output.AppendText(p + "\r\n");
                output.ScrollToCaret();
            }
        }

        //Abfangen ob Enter-Taste gedrückt wurde
        private void input_KeyDown(object sender, KeyEventArgs e)
        {
            if (e.KeyCode == Keys.Enter)
            {
                p.StandardInput.WriteLine(input.Text);
                input.Text = string.Empty;
            }
        }

        //+

        
        //Rückruf über ein Ereignis
        //Häufig verwendet bei asynchronen Methoden in .NET
        //Ältere .NET Funktionen geben außerdem einen Handler, welcher Informationen zur async Methode besitzt
        //Oftmals kann man wählen: sync oder async?
    }
}
